<?php
/*--------------------------------------------------------------------
 ReadService.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Service;

use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\PropertiesCombinationIdDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO\CombinationModelDto;
use Gambio\Shop\Properties\SellingUnitModel\Database\Repository\RepositoryInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function combinationModel(PropertiesCombinationIdDto $propertiesValuesIdDto): CombinationModelDto
    {
        return $this->repository->combinationModel($propertiesValuesIdDto);
    }
}